/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.python.posix.POSIXHandler;

public class ExecIt {
    POSIXHandler handler;

    public ExecIt(POSIXHandler pOSIXHandler) {
        this.handler = pOSIXHandler;
    }

    public int runAndWait(String ... stringArray) throws IOException, InterruptedException {
        return this.runAndWait(this.handler.getOutputStream(), stringArray);
    }

    public int runAndWait(OutputStream outputStream, String ... stringArray) throws IOException, InterruptedException {
        Process process = this.run(stringArray);
        this.handleStreams(process, this.handler.getInputStream(), outputStream, this.handler.getErrorStream());
        return process.waitFor();
    }

    public Process run(String ... stringArray) throws IOException {
        File file = this.handler.getCurrentWorkingDirectory();
        return Runtime.getRuntime().exec(stringArray, this.handler.getEnv(), file);
    }

    private void handleStreams(Process process, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        InputStream inputStream2 = process.getInputStream();
        InputStream inputStream3 = process.getErrorStream();
        OutputStream outputStream3 = process.getOutputStream();
        StreamPumper streamPumper = new StreamPumper(inputStream2, outputStream, false);
        StreamPumper streamPumper2 = new StreamPumper(inputStream3, outputStream2, false);
        StreamPumper streamPumper3 = new StreamPumper(inputStream, outputStream3, true);
        streamPumper.start();
        streamPumper2.start();
        streamPumper3.start();
        try {
            streamPumper.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            streamPumper2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        streamPumper3.quit();
        try {
            outputStream2.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            outputStream3.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            inputStream3.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class StreamPumper
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private boolean onlyIfAvailable;
        private volatile boolean quit;
        private final Object waitLock = new Object();

        StreamPumper(InputStream inputStream, OutputStream outputStream, boolean bl) {
            this.in = inputStream;
            this.out = outputStream;
            this.onlyIfAvailable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] byArray = new byte[1024];
            boolean bl = false;
            try {
                while (!this.quit) {
                    int n;
                    if (this.onlyIfAvailable && !bl) {
                        if (this.in.available() == 0) {
                            Object object = this.waitLock;
                            synchronized (object) {
                                this.waitLock.wait(10L);
                                continue;
                            }
                        }
                        bl = true;
                    }
                    if ((n = this.in.read(byArray)) == -1) {
                        break;
                    }
                    this.out.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (this.onlyIfAvailable) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }
}

